package com.agilex.healthcare.veteranappointment.datalayer.patient;

import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.veteranappointment.datalayer.AbstractDao;

@Repository
public class PatientMetadataDao extends AbstractDao {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(PatientMetadataDao.class);

	public List<PatientMetadataPo> getPatientMetadata() {
		String selectAppointmentRequests = "from PatientMetadataPo ";
		Query query = getQuery(selectAppointmentRequests);
		
		List<PatientMetadataPo> patientMetadataList = this.executeForPatientMetadataList(query);
		return patientMetadataList;
	}
	
	public PatientMetadataPo getPatientMetadata(String patientId) {
		String selectSingleAppointmentRequest = "from PatientMetadataPo where userId = :userId ";
		Query query = getQuery(selectSingleAppointmentRequest);
		query.setParameter("userId", patientId);

		return this.executeForPatientMetadata(query);
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public PatientMetadataPo savePatientMetadata(PatientMetadataPo patientMetadata) {
		PatientMetadataPo mergedPatientMetadata = entityManager.merge(patientMetadata);
		return mergedPatientMetadata;
	}

	private List<PatientMetadataPo> executeForPatientMetadataList(Query query) {
		@SuppressWarnings("unchecked")
		List<PatientMetadataPo> patientMetadataResults = query.getResultList();
		
		return patientMetadataResults;
	}

	private PatientMetadataPo executeForPatientMetadata(Query query) {
		try {
			return (PatientMetadataPo) query.getSingleResult();
		} catch (NoResultException e) {
			throw new WebApplicationException(Status.NOT_FOUND);
		} catch (NonUniqueResultException e) {
			throw new WebApplicationException(Status.PRECONDITION_FAILED);
		}
	}

	private Query getQuery(String dbQuery) {
		Query query = this.entityManager.createQuery(dbQuery);
		return query;
	}
}
